
-- Funktion ruft http_get auf setzt aber zuvor noch CURLOPT_CAINFO
-- zum Abruf von HTTPS-Requests in einem F2/F4
CREATE OR REPLACE FUNCTION x_10_interfaces.http_get__incl_curlopt(
      IN  request varchar,
      OUT content varchar
    ) RETURNS varchar AS $$
  BEGIN

    PERFORM http_set_curlopt('CURLOPT_CAINFO', TSystem.Settings__GetText( 'HTTP-curl-ca-bundle-PATH' ));

    SELECT http_get.content INTO content FROM http_get(request);

  END $$ LANGUAGE plpgsql;
--

-- Funktion ruft Feiertage und Ferien von der openholidays API ab
CREATE OR REPLACE FUNCTION x_10_interfaces.openholidaysapi__Feiertage_Schulferien_get(
      IN _typ            integer,                                                                   -- 0 - Feiertage, 1 - Schulferien
      IN _land           varchar,
      IN _bundesland     varchar,
      IN _datum_von      date DEFAULT DATE_TRUNC('year', CURRENT_DATE),                             -- Standard ist 01.01. des aktuellen Jahres
      IN _datum_bis      date DEFAULT DATE_TRUNC('year', CURRENT_DATE) + INTERVAL '1 year - 1 day'  -- Standard ist 31.12. des aktuellen Jahres
    ) RETURNS VOID AS $$
  DECLARE
          _url               varchar;
          _content           jsonb;
          _event             jsonb;
          _ft_name_v         varchar;
          _ft_endDate_v      date;
          _ft_startDate_v    date;
  BEGIN

    -- Prüfen ob Eingangsparameter korrekt gesetzt sind
    IF NOT _typ IN (0,1)
        OR _land IS NULL THEN
      raise exception 'Falscher Eingangsparameter';
    END IF;

    -- URL zusammenbauen um Events von API abzurufen
    _url := concat( 'https://openholidaysapi.org/',
                    CASE _typ
                      WHEN 0 THEN 'PublicHolidays'
                      WHEN 1 THEN 'SchoolHolidays'
                    END,
                    '?countryIsoCode=',   trim( _land ),
                    '&languageIsoCode=',  trim( _land ),
                    '&validFrom=',        trim( _datum_von ),
                    '&validTo=',          trim( _datum_bis ),
                    CASE WHEN _bundesland IS NOT NULL THEN
                      '&subdivisionCode=' || trim( _bundesland )
                    END
                  );

    -- gesonderter Block für Exception Handling
    BEGIN
      IF  char_length( trim( TSystem.Settings__GetText( 'HTTP-curl-ca-bundle-PATH' ) ) ) > 0 THEN     --- Setting 'HTTP-curl-ca-bundle-PATH' ist  nicht eingegeben
          PERFORM http_set_curlopt('CURLOPT_CAINFO', TSystem.Settings__GetText( 'HTTP-curl-ca-bundle-PATH' ));
      END IF;

      SELECT content::jsonb INTO _content
        FROM http_get(_url);

    EXCEPTION
      WHEN OTHERS THEN
        RAISE WARNING 'x_10_interfaces.openholidaysapi__Feiertage_Schulferien_get ERROR, missing implementation error handling';
    END;

    -- Überprüfen, ob die Anfrage erfolgreich war
    IF _content IS NOT NULL THEN

      -- abgerufene Events in Kalender schreiben
      FOR _event IN SELECT jsonb_array_elements(_content) LOOP
        _ft_name_v      := _event -> 'name' -> 0 ->> 'text';
        _ft_startDate_v := _event ->> 'startDate';
        _ft_endDate_v   := _event ->> 'endDate';

        raise notice '_ft_name_v      = %', _ft_name_v;
        raise notice '_ft_startDate_v = %', _ft_startDate_v;
        raise notice '_ft_endDate_v   = %', _ft_endDate_v;
        ---
        raise notice '*********************************************';

        ---
        IF _typ = 0 THEN
            INSERT INTO feiertag ( ft_bez, ft_date )
              SELECT _ft_name_v, _ft_startDate_v
              WHERE NOT EXISTS ( SELECT true FROM feiertag WHERE ft_date = _ft_startDate_v );
        ELSE
            INSERT INTO ferien ( fte_bez, fte_anf, fte_end )
              SELECT _ft_name_v, _ft_startDate_v, _ft_endDate_v
              WHERE NOT EXISTS ( SELECT true FROM ferien WHERE fte_anf = _ft_startDate_v );
        END IF;

      END LOOP;

    END IF;

  END $$ LANGUAGE plpgsql;